/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.client.render;

import com.flemmli97.tenshilib.client.render.MoreRenderTypes;
import com.flemmli97.tenshilib.mixin.WorldRenderAccessor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    public static final int defaultColor = -1;

    public static void renderBlockOutline(MatrixStack matrixStack, IRenderTypeBuffer buffer, PlayerEntity player, BlockPos pos, float partialTicks) {
        RenderUtils.renderBlockOutline(matrixStack, buffer, player, pos, partialTicks, 0.0f, 0.0f, 0.0f, 1.0f, false);
    }

    public static void renderBlockOutline(MatrixStack matrixStack, IRenderTypeBuffer buffer, PlayerEntity player, BlockPos pos, float partialTicks, float red, float green, float blue, float alpha, boolean ignoreDepth) {
        BlockState state = player.field_70170_p.func_180495_p(pos);
        IVertexBuilder build = ignoreDepth ? buffer.getBuffer(MoreRenderTypes.LINE_NODEPTH) : buffer.getBuffer(RenderType.func_228659_m_());
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d rpos = renderInfo.func_216785_c();
        WorldRenderAccessor.drawShapeOutline(matrixStack, build, state.func_215700_a((IBlockReader)player.field_70170_p, pos, ISelectionContext.func_216374_a((Entity)player)), rpos.field_72450_a, rpos.field_72448_b, rpos.field_72449_c, red, green, blue, alpha);
    }

    public static void renderAreaAround(MatrixStack matrixStack, IRenderTypeBuffer buffer, PlayerEntity player, BlockPos pos, float partialTicks, float radius) {
        RenderUtils.renderBoundingBox(matrixStack, buffer, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g((double)radius).func_186670_a(pos.func_177977_b()), player, partialTicks);
    }

    public static void renderAreaAround(MatrixStack matrixStack, IRenderTypeBuffer buffer, PlayerEntity player, BlockPos pos, float partialTicks, float radius, float red, float green, float blue, float alpha, boolean ignoreDepth) {
        RenderUtils.renderBoundingBox(matrixStack, buffer, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g((double)radius).func_186670_a(pos.func_177977_b()), player, partialTicks, red, green, blue, alpha, ignoreDepth);
    }

    public static void renderBoundingBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, AxisAlignedBB aabb, PlayerEntity player, float partialTicks) {
        RenderUtils.renderBoundingBox(matrixStack, buffer, aabb, player, partialTicks, 1.0f, 0.5f, 0.5f, 1.0f, false);
    }

    public static void renderBoundingBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, AxisAlignedBB aabb, PlayerEntity player, float partialTicks, float red, float green, float blue, float alpha, boolean ignoreDepth) {
        double playerX = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)partialTicks;
        double playerY = player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partialTicks;
        double playerZ = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)partialTicks;
        IVertexBuilder build = ignoreDepth ? buffer.getBuffer(MoreRenderTypes.LINE_NODEPTH) : buffer.getBuffer(RenderType.func_228659_m_());
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)build, (AxisAlignedBB)aabb.func_186662_g((double)0.002f).func_72317_d(-playerX, -playerY, -playerZ), (float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void renderTexture(MatrixStack matrixStack, IRenderTypeBuffer buffer, ResourceLocation texture, double x, double y, double z, float xSize, float ySize, float red, float green, float blue, float alpha, float yawRot, float pitchRot) {
        RenderUtils.renderTexture(matrixStack, buffer, texture, x, y, z, xSize, ySize, (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f), yawRot, pitchRot);
    }

    public static void renderTexture(MatrixStack matrixStack, IRenderTypeBuffer buffer, ResourceLocation texture, double x, double y, double z, float xSize, float ySize, int red, int green, int blue, int alpha, float yawRot, float pitchRot) {
        RenderUtils.renderTexture(matrixStack, buffer, texture, x, y, z, xSize, ySize, red, green, blue, alpha, yawRot, pitchRot, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void renderTexture(MatrixStack matrixStack, IRenderTypeBuffer buffer, ResourceLocation texture, double x, double y, double z, float xSize, float ySize, int red, int green, int blue, int alpha, float yawRot, float pitchRot, float u, float v, float uLength, float vLength) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(x, y + 0.2, z);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yawRot));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitchRot));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        IVertexBuilder build = buffer.getBuffer(MoreRenderTypes.TEXTURED_QUAD);
        build.func_225582_a_((double)(-(xSize /= 2.0f)), (double)(ySize /= 2.0f), 0.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(u, v).func_181675_d();
        build.func_225582_a_((double)xSize, (double)ySize, 0.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(u + uLength, v).func_181675_d();
        build.func_225582_a_((double)xSize, (double)(-ySize), 0.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(u + uLength, v + vLength).func_181675_d();
        build.func_225582_a_((double)(-xSize), (double)(-ySize), 0.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(u, v + vLength).func_181675_d();
        matrixStack.func_227865_b_();
    }

    public static void renderTexture(MatrixStack matrixStack, IRenderTypeBuffer buffer, ResourceLocation texture, double x, double y, double z, float xSize, float ySize, int hexColor, float yawRot, float pitchRot) {
        int red = hexColor >> 16 & 0xFF;
        int green = hexColor >> 8 & 0xFF;
        int blue = hexColor & 0xFF;
        int alpha = hexColor >> 24 & 0xFF;
        RenderUtils.renderTexture(matrixStack, buffer, texture, x, y, z, xSize, ySize, red, green, blue, alpha, yawRot, pitchRot);
    }
}

